// Computing rational points of bounded height 

load "FiberProductsData.m";
load "MaximalCurvesFinitelyManyPoints.m";

SetMemoryLimit(50*10^9);


genera:=Sort(Setseq(Keys(MaximalCurvesByGenus)));

genera:=Sort([g : g in genera | g ge 3]);


jCM:={0,1728,2^4*3^3*5^3,2^3*3^3*11^3,-3^3*5^3,3^3*5^3*17^3,2^6*5^3,-2^(15)*3*5^3,-2^(15),-2^(15)*3^3,-2^(18)*3^3*5^3,-2^(15)*3^3*5^3*11^3,-2^(18)*3^3*5^3*23^3*29^3};

for g in genera do
	printf "==================== g = %o ====================\n",g;
	for k in MaximalCurvesByGenus[g] do
	if not k in {["7B","11Nn"],["5Nn","11Nn"],["11Nn","13B"],["7Nn","11Nn"],["7Ns","11Nn"]} then
    	printf "==== %o ====\n",k;
		if not ("11Nn" in Seqset(k)) then
			bound:=10^6;
			C:=FiberProducts[k]`curve;
			G1:=k[1];
			G2:=k[2];
			j1:=Groups[G1]`jmap;	
			j2:=Groups[G2]`jmap;
			Pts0:=PointSearch(C,bound);
			Pts:=[pt : pt in Pts0 | (Evaluate(Denominator(j1),pt[1]) ne 0) and (Evaluate(Denominator(j2),pt[2]) ne 0) and (pt[3] ne 0)];
			assert &and{Evaluate(j1,pt[1]/pt[3]) eq  Evaluate(j2,pt[2]/pt[3]) : pt in Pts};	
			js:={Evaluate(j1,pt[1]/pt[3]): pt in Pts};
			Ptsj:=<>;
			for pt in Pts do
				jpt:=Evaluate(j1,pt[1]/pt[3]);
				ptt:=[pt[1]/pt[3],pt[2]/pt[3]];
				printf "%o -> %o\n",pt,jpt;
				Ptsj:=Append(Ptsj,<ptt,jpt>);
			end for;
		    printf "------------------------------------------------------> %o\n", js diff jCM;
    		if #(js diff jCM) ne 0 then print "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"; end if;
    		if #js eq 0 then
    			for p in PrimesInInterval(2,100) do
    				if not IsLocallySolvable(C,p) then
    					printf "XXXXXXXXXXX Non Locally Solvable at p=%o XXXXXXXXXXXXXXXXXXXXXXXXX\n",p;
    					break;
    				end if;
    			end for;
    		end if;
    		fprintf "output_RPBF.txt","<[\"%o,%o\"],%o,%o>,\n",k[1],k[2],Ptsj,js diff jCM;
  		else
    		bound:=100;
    		C:=FiberProducts[k]`curve;
			G1:=k[1];
			G2:=k[2];
			if G1 eq "11Nn" then j:=Groups[G2]`jmap; end if;
			if G2 eq "11Nn" then j:=Groups[G1]`jmap; end if;
			Pts0:=PointSearch(C,bound);
			Pts0:=[pt : pt in Pts0 | pt[3] ne 0];
			Pts:=[pt : pt in Pts0 | Evaluate(Denominator(j),pt[2]/pt[3]) ne 0];
			js:={Evaluate(j,pt[2]/pt[3]): pt in Pts};			
			Ptsj:=<>;
			for pt in Pts do
				jpt:=Evaluate(j,pt[2]/pt[3]);
				ptt:=[pt[1]/pt[3],pt[2]/pt[3]];
				printf "%o -> %o\n",pt,jpt;
				Ptsj:=Append(Ptsj,<ptt,jpt>);
			end for;
		    printf "-----------------------> %o\n", js diff jCM;
    		if #(js diff jCM) ne 0 then print "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"; end if;
    		if #js eq 0 then
    			for p in PrimesInInterval(2,100) do
    				if not IsLocallySolvable(C,p) then
    					printf "XXXXXXXXXXX Non Locally Solvable at p=%o XXXXXXXXXXXXXXXXXXXXXXXXX\n",p;
    					break;
    				end if;
    			end for;
    		end if;
    		fprintf "output_RPBF.txt","<[\"%o,%o\"],%o,%o>,\n",k[1],k[2],Ptsj,js diff jCM;
		end if;
	end if;
	end for;
end for;



//jCM:={0,1728,2^4*3^3*5^3,2^3*3^3*11^3,-3^3*5^3,3^3*5^3*17^3,2^6*5^3,-2^(15)*3*5^3,-2^(15),-2^(15)*3^3,-2^(18)*3^3*5^3,-2^(15)*3^3*5^3*11^3,-2^(18)*3^3*5^3*23^3*29^3};
// k:=["7B","11Nn"]; // g=32 atkin
// k:=["5Nn","11Nn"]; // g=38 lehner
// k:=["11Nn","13B"]; // g=56 atkin
// k:=["7Nn","11Nn"]; // g=81 atkin
//k:=["7Ns","11Nn"]; // g=112 lehner

S:=[["7B","11Nn"],["5Nn","11Nn"],["11Nn","13B"],["7Nn","11Nn"],["7Ns","11Nn"]];

bound:=100;

for j in [1..#S] do
	C:=FiberProducts[S[j]]`curve;
	PointSearch(C,bound: OnlyOne:=true);
end for;




